using System;
using System.Data;
using System.Data.SqlClient;
using WRKEVENT_TABLE = gov.va.med.vbecs.Common.VbecsTables.WorkloadEvent;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carrie Van Stedum</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>04/23/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// WorkloadEvent data access layer class.
	///</summary>

	#endregion
	
	public class WorkloadEvent
	{
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/10/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1212"> 
		///		<ExpectedInput>vbecsProcessID</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1213"> 
		///		<ExpectedInput>Invalid ProcessID</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetWorkloadProcessGuidByProcessID
		/// </summary>
		/// <param name="vbecsProcessID"></param>
		/// <returns></returns>
		public static System.Data.DataTable GetWorkloadProcessGuidByProcessID(int vbecsProcessID)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetWorkloadProcessGuidByVbecsProcessID.vbecsprocessid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.GetWorkloadProcessGuidByVbecsProcessID.divisioncode, System.Data.SqlDbType.VarChar)
			};
			prms[0].Value = vbecsProcessID;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			System.Data.DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetWorkloadProcessGuidByVbecsProcessID.StoredProcName, prms).Tables[0];
			return dt;
		}


		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/10/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2193"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2194"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get the list of workload for the Division Workload Report
		/// </summary>
		/// <param name="singleDivision"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <param name="divisionCode"></param>
		/// <returns></returns>
		public static System.Data.DataTable GetDivisionWorkloadReport(bool singleDivision, DateTime startDate, DateTime endDate, string divisionCode)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetDivisionWorkloadReport.divisioncode, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetDivisionWorkloadReport.singledivision, System.Data.SqlDbType.Bit),
				new SqlParameter(STOREDPROC.GetDivisionWorkloadReport.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetDivisionWorkloadReport.enddate, System.Data.SqlDbType.DateTime)
			};

			prms[0].Value = divisionCode;
			prms[1].Value = singleDivision;
			prms[2].Value = startDate;
			prms[3].Value = endDate;
			
			System.Data.DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetDivisionWorkloadReport.StoredProcName, prms).Tables[0];
			return dt;
		}
	}
}
